﻿using System;

namespace IMMeDotNet {

	/// <summary>
	/// Represents a message that has been sent or received.
	/// </summary>
	public class Message {

		/// <summary>
		/// The <see cref="Contact"/> who sent or is to send the message.
		/// </summary>
		public Contact Sender { get; private set; }
		
		/// <summary>
		/// The <see cref="Contact"/> who received or is to receive the message.
		/// </summary>
		public Contact Recipient { get; private set; }

		/// <summary>
		/// The contents of the message.
		/// </summary>
		public IMMeString Text { get; private set; }

		/// <summary>
		/// Creates an instance of the <see cref="Message"/> class from an existing sender, recipient and message.
		/// </summary>
		/// <param name="sender">The <see cref="Contact"/> who sent or is to send the message.</param>
		/// <param name="recipient">The <see cref="Contact"/> who received or is to receive the message.</param>
		/// <param name="text">The contents of the message.</param>
		public Message(Contact sender, Contact recipient, IMMeString text) {
			this.Sender = sender;
			this.Recipient = recipient;
			this.Text = text;
		}

		/// <summary>
		/// Converts the <see cref="Message"/> into a string.
		/// </summary>
		public override string ToString() {
			return string.Format("{{Sender={0},Recipient={1},Text={2}}}", this.Sender, this.Recipient, this.Text);
		}

	}
}
